<?php

namespace App\Telegram\Menus\Admin;

use App\Models\Asset;
use App\Models\Folder;
use App\Telegram\Menus\InlineMenuPaginator;
use SergiX44\Nutgram\Conversations\InlineMenu;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;

class AssetsMenu extends InlineMenuPaginator
{
    use Helpers;

    protected int $folderId;


    public function start(Nutgram $bot): void
    {
        if (!self::authorizeAdmin($bot, $this)) return;


        $this->menuText("📎 **Asset Management**\n\nSelect an action:", ['parse_mode' => 'Markdown'])
            ->clearButtons()
            ->addButtonRow(InlineKeyboardButton::make('➕ Add Asset', callback_data: 'add@startAddConversation'))
            ->addButtonRow(InlineKeyboardButton::make('🗑 Delete Asset', callback_data: 'delete@startDeleteConversation'))
            ->addButtonRow(InlineKeyboardButton::make('⬅️ Back', callback_data: 'back@goBack'))
            ->showMenu();
    }

    public function goBack(Nutgram $bot): void
    {
        $this->end();
        AdminMenu::begin($bot);
    }

    public function startAddConversation(Nutgram $bot): void
    {
        $this->end();
        AddAssetConversation::begin($bot);
    }

    function startDeleteConversation(Nutgram $bot): void
    {
        $this->end();
        DeleteAssetConversation::begin($bot);
    }

    // Deletion Flow
    public function showFoldersForDeletion(Nutgram $bot): void
    {
        $folders = Folder::orderBy('name')->get();
        if ($folders->isEmpty()) {
            $bot->answerCallbackQuery('No folders found. Please create a folder first.');
            return;
        }

        $this->menuText("🗑️ **Delete Asset**\n\nFirst, select the folder containing the asset:", ['parse_mode' => 'Markdown'])
            ->clearButtons();

        foreach ($folders as $folder) {
            $this->addButtonRow(InlineKeyboardButton::make(
                "📁 {$folder->getPath()}",
                callback_data: "{$folder->id}@showAssetsToDelete"
            ));
        }
        $this->addButtonRow(InlineKeyboardButton::make('⬅️ Back', callback_data: 'back@start'));
        $this->showMenu();
    }

    public function showAssetsToDelete(Nutgram $bot): void
    {
        $this->folderId = (int)$bot->callbackQuery()->data;
        $assets = Asset::where('folder_id', $this->folderId)->orderBy('title')->get();

        if ($assets->isEmpty()) {
            $bot->answerCallbackQuery($bot->callbackQuery()->id, 'This folder has no assets.');
            return;
        }

        $this->menuText('🗑️ **Delete Asset**\n\nNow, select the asset to delete:', ['parse_mode' => 'Markdown'])
            ->clearButtons();

        foreach ($assets as $asset) {
            $this->addButtonRow(InlineKeyboardButton::make(
                "{$asset->getIcon()} {$asset->title}", // Using a model accessor for the icon
                callback_data: "{$asset->id}@handleDelete"
            ));
        }
        $this->addButtonRow(InlineKeyboardButton::make('⬅️ Back to Folders', callback_data: 'back@showFoldersForDeletion'));
        $this->showMenu();
    }

    public function handleDelete(Nutgram $bot): void
    {
        $assetId = (int)$bot->callbackQuery()->data;
        $asset = Asset::find($assetId);

        if (!$asset) {
            $bot->answerCallbackQuery($bot->callbackQuery()->id, 'Asset not found!');
            return;
        }

        $assetTitle = $asset->title;
        $asset->delete();

        $this->menuText("✅ Asset '{$assetTitle}' has been deleted successfully.")
            ->clearButtons()
            ->addButtonRow(InlineKeyboardButton::make('⬅️ Back to Assets Menu', callback_data: 'back@start'))
            ->showMenu();
    }

    protected function renderPage(Nutgram $bot, ?int $folderId, int $page, array $data = null): void
    {
        // TODO: Implement renderPage() method.
    }
}
