<?php

namespace App\Telegram\Menus\Admin;

use App\Models\User;
use Illuminate\Pagination\LengthAwarePaginator;
use SergiX44\Nutgram\Conversations\Conversation;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardMarkup;

trait Helpers
{
    function handleUserCreation(Nutgram $bot): void
    {
        User::updateOrCreate(
            [
                'telegram_id' => $bot->userId(),
            ],
            [
                'username' => $bot->user()->username,
                'first_name' => $bot->user()->first_name,
                'last_name' => $bot->user()->last_name,
            ]
        );
    }

    function isRootAdmin(Nutgram $bot): bool
    {
        $user = $bot->user();
        return $user && in_array($user->id, AdminMenu::$adminIds);
    }

    function isAdmin(Nutgram $bot): bool
    {
        $user = $bot->user();
        $isUserAdmin = User::on()->where('telegram_id', $user->id)->where('is_admin', true)->exists();

        return $user && ($isUserAdmin || $this->isRootAdmin($bot));
    }

    function authorizeAdmin(Nutgram $bot, Conversation $menu = null, string $customMessage = null): bool
    {
        if (!self::isAdmin($bot)) {
            $bot->sendMessage($customMessage ?? 'You are not authorized to use admin commands.');

            $menu?->end();

            return false;
        }

        return true;
    }


    function addConversationControls(LengthAwarePaginator $paginator, InlineKeyboardMarkup $keyboardMarkup): void
    {
        $paginationButtons = [];

        if ($paginator->currentPage() > 1) {
            $previousPage = $paginator->currentPage() - 1;
            $paginationButtons[] = InlineKeyboardButton::make(
                '⬅️ Prev',
                callback_data: "{$previousPage}@handlePagination"
            );
        }

        if ($paginator->lastPage() > 1) { // Only show page number if there's more than one page
            $paginationButtons[] = InlineKeyboardButton::make(
                "{$paginator->currentPage()}/{$paginator->lastPage()}",
                callback_data: 'noop'
            );
        }

        if ($paginator->hasMorePages()) {
            $nextPage = $paginator->currentPage() + 1;
            $paginationButtons[] = InlineKeyboardButton::make(
                'Next ➡️',
                callback_data: "{$nextPage}@handlePagination"
            );
        }

        if (!empty($paginationButtons)) $keyboardMarkup->addRow(...$paginationButtons);
    }
}
