<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<li class="list-group-item d-flex justify-content-between align-items-center folder-item"
    data-folder-id="{{ $folder->id }}"
    style="cursor: pointer; transition: background 0.2s;">
    
    <div class="d-flex align-items-center gap-3">

        <!-- Folder Icon + Name -->
        <strong class="d-flex align-items-center gap-2 fs-5">
            <i class="bi bi-folder2-open text-warning"></i>
            {{ $folder->name }}
        </strong>

        <!-- Access Badge -->
        @if ($folder->users->count() > 0)
            <span class="badge bg-body-secondary text-dark rounded-pill d-flex align-items-center gap-2 px-3 py-2">
                <i class="bi bi-people"></i>
                {{ $folder->users->count() }} user{{ $folder->users->count() > 1 ? 's' : '' }}
            </span>
        @endif

    </div>

    <a href="{{ route('admin.folders.confirmDelete', $folder) }}"
       class="btn btn-outline-danger btn-sm d-flex align-items-center gap-2"
       onclick="event.stopPropagation()">
        <i class="bi bi-trash"></i>
        Delete
    </a>
</li>

<style>
    .folder-item:hover {
        background: #f8f9fa;
    }
</style>
