
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<?php $__env->startSection('content'); ?>
    <div id="page-overlay"></div>

    <div class="d-flex flex-wrap justify-content-between align-items-start mb-4 p-3 rounded-3 bg-light border">

    <!-- Left Section -->
    <div>
        <h2 class="fw-bold mb-2 d-flex align-items-center gap-2">
            <i class="bi bi-folder-fill text-primary"></i>
            <span>Folder Management</span>
        </h2>

        <div class="text-muted">
            <div class="mb-1">
                <i class="bi bi-geo-alt-fill me-1"></i>
                <strong><?php echo e($path); ?></strong>
            </div>
            <div>
                <i class="bi bi-hash me-1"></i>
                <strong id="folder-id-field">NULL</strong>
            </div>
        </div>
    </div>

    <!-- Right Section -->
    <div class="d-flex flex-wrap gap-2 mt-3 mt-md-0">

        <!-- Sort -->
        <button id="sort-btn"
                class="btn btn-outline-secondary d-flex align-items-center gap-1 px-3">
            <i class="bi bi-arrow-down-up"></i>
            Sort
        </button>

        <!-- Create Folder -->
        <a id="create-folder-btn"
           href="<?php echo e(route('admin.folders.create')); ?>"
           class="btn btn-primary d-flex align-items-center gap-1 px-3">
            <i class="bi bi-plus-lg"></i>
            Create
        </a>

        <!-- Grant Access -->
        <a id="grant-access-btn"
           href="<?php echo e(route('admin.folders.grant.form')); ?>"
           class="btn btn-success d-flex align-items-center gap-1 px-3">
            <i class="bi bi-unlock-fill"></i>
            Grant Access
        </a>

        <!-- Revoke Access -->
        <a id="revoke-access-btn"
           href="<?php echo e(route('admin.folders.revoke.form')); ?>"
           class="btn btn-warning d-flex align-items-center gap-1 px-3">
            <i class="bi bi-lock-fill"></i>
            Revoke Access
        </a>

    </div>
</div>
  <div class="card shadow-sm border-0">
    <div class="card-header d-flex justify-content-between align-items-center bg-white py-3">

        <div class="d-flex align-items-center gap-2">
            <?php if($backUrl): ?>
                <a id="back-btn"
                   href="<?php echo e($backUrl); ?>"
                   class="btn btn-outline-primary btn-sm d-flex align-items-center gap-1">
                    <i class="bi bi-arrow-left"></i>
                    Back
                </a>
            <?php endif; ?>

            <h5 class="mb-0 fw-semibold d-flex align-items-center gap-2">
                <i class="bi bi-diagram-3-fill text-primary"></i>
                Folder Structure
            </h5>
        </div>

        <small class="text-muted d-none d-md-inline">
            Click a folder to select it
        </small>

    </div>

        <?php if($folders->isEmpty()): ?>
            
        <?php else: ?>
            <div class="card-body">
                <ul id="sortable-folders" class="list-group">
                    <?php $__currentLoopData = $folders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo $__env->make('admin.folders._folder_list_item', ['folder' => $folder], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if($assets->isEmpty()): ?>
            
        <?php else: ?>
            <div class="card-body">

                <ul class="list-group">
                    <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo $__env->make('admin.folders._asset_list_item', ['asset' => $asset], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<style>
    #page-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.5); /* or darker */
        z-index: 9999;
        display: none;
        cursor: wait;
    }

    .folder-item.active {
        background-color: #e9ecef; /* A light grey background */
        font-weight: bold;
    }

    /* Sortable styles */
    .sortable-container {
        min-height: 50px;
    }

    .sortable-item {
        cursor: move;
    }

    .sortable-placeholder {
        height: 40px;
        background-color: #f8f9fa;
        border: 2px dashed #dee2e6;
        margin: 5px 0;
        border-radius: 5px;
    }

    .sortable-ghost {
        opacity: 0.4;
        background-color: #e9ecef;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
<script>
    function disablePage() {
        document.getElementById('page-overlay').style.display = 'block';
    }

    function enablePage() {
        document.getElementById('page-overlay').style.display = 'none';
    }

    document.addEventListener('DOMContentLoaded', function () {
        const folderIdField = document.getElementById('folder-id-field');
        const createBtn = document.getElementById('create-folder-btn');
        const grantBtn = document.getElementById('grant-access-btn');
        const revokeBtn = document.getElementById('revoke-access-btn');

        const originalCreateUrl = createBtn.href;
        const originalGrantUrl = grantBtn.href;
        const originalRevokeUrl = revokeBtn.href;

        const folderItems = document.querySelectorAll('.folder-item');
        let currentSelected = null;
        let isSortingMode = false;
        const sortBtn = document.getElementById('sort-btn');

        const urlFolderId = new URLSearchParams(window.location.search).get('folder_id');

        resetButtonUrls();
        folderIdField.innerHTML = "Home";

        if (urlFolderId) {
            folderIdField.innerHTML = urlFolderId;
            updateButtonUrls(urlFolderId);
        }


        // Initialize Sortable for each level
        function initSortable() {
            const sortableContainers = document.querySelectorAll('.list-group');

            sortableContainers.forEach(container => {
                if (!container.classList.contains('sortable-initialized')) {
                    container.classList.add('sortable-initialized');

                    new Sortable(container, {
                        group: 'nested',
                        animation: 150,
                        fallbackOnBody: true,
                        swapThreshold: 0.65,
                        ghostClass: 'sortable-ghost',
                        chosenClass: 'sortable-chosen',
                        dragClass: 'sortable-drag',
                        disabled: true,
                        onEnd: function (evt) {
                            // Send all folder orders to server
                            updateAllFolderOrders();
                        }
                    });
                }
            });
        }

        // Initialize all containers
        initSortable();

        // Toggle sorting mode
        sortBtn.addEventListener('click', function () {
            isSortingMode = !isSortingMode;

            if (isSortingMode) {
                sortBtn.innerHTML = '✅ Done Sorting';
                sortBtn.classList.remove('btn-info');
                sortBtn.classList.add('btn-success');

                // Enable sorting for all containers
                document.querySelectorAll('.list-group').forEach(container => {
                    const sortable = Sortable.get(container);
                    if (sortable) {
                        sortable.option('disabled', false);
                    }
                });

                // Add cursor styles
                document.querySelectorAll('.folder-item').forEach(item => {
                    item.classList.add('sortable-item');
                });
            } else {
                sortBtn.innerHTML = '↕️ Sort Folders';
                sortBtn.classList.remove('btn-success');
                sortBtn.classList.add('btn-info');

                // Disable sorting for all containers
                document.querySelectorAll('.list-group').forEach(container => {
                    const sortable = Sortable.get(container);
                    if (sortable) {
                        sortable.option('disabled', true);
                    }
                });

                // Remove cursor styles
                document.querySelectorAll('.folder-item').forEach(item => {
                    item.classList.remove('sortable-item');
                });
            }
        });

        // Folder selection handling
        folderItems.forEach(item => {
            item.addEventListener('click', function (e) {
                // Only process click if not in sorting mode
                if (!isSortingMode) {
                    const folderId = this.dataset.folderId;

                    window.location.href = "?folder_id=" + folderId;

                    // If the clicked item is already selected, deselect it
                    if (this.classList.contains('active')) {
                        this.classList.remove('active');
                        currentSelected = null;
                    } else {
                        if (currentSelected) {
                            currentSelected.classList.remove('active');
                        }

                        this.classList.add('active');
                        currentSelected = this;
                    }
                }

                // Prevent default behavior if clicking on delete button
                if (e.target.classList.contains('btn-danger')) {
                    e.stopPropagation();
                }
            });
        });

        function updateButtonUrls(folderId) {
            createBtn.href = `${originalCreateUrl}?parent_id=${folderId}`;
            grantBtn.href = `${originalGrantUrl}?folder_id=${folderId}`;
            revokeBtn.href = `${originalRevokeUrl}?folder_id=${folderId}`;
        }

        function resetButtonUrls() {
            createBtn.href = originalCreateUrl;
            grantBtn.href = originalGrantUrl;
            revokeBtn.href = originalRevokeUrl;
        }

        function collectAllFolderOrders() {
            const orders = [];

            document.querySelectorAll('.list-group').forEach(container => {
                const items = container.querySelectorAll('[data-folder-id]');
                items.forEach((item, index) => {
                    const folderId = item.dataset.folderId;

                    orders.push({
                        folder_id: folderId,
                        position: index
                    });
                });
            });

            return orders;
        }

        function collectAllAssetOrders() {
            const orders = [];

            document.querySelectorAll('.list-group').forEach(container => {
                const items = container.querySelectorAll('[data-asset-id]');
                items.forEach((item, index) => {
                    const folderId = item.dataset.assetId;

                    orders.push({
                        asset_id: folderId,
                        position: index
                    });
                });
            });

            return orders;
        }

        function updateAllFolderOrders() {
            disablePage();

            const folderOrders = collectAllFolderOrders();
            const assetOrders = collectAllAssetOrders();

            if (folderOrders.length === 0 && assetOrders.length === 0) {
                enablePage();
            }

            if (folderOrders.length > 0) {
                fetch('<?php echo e(route("admin.folders.updateOrder")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        folder_orders: folderOrders
                    })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (!data.success) {
                            alert('Error updating folder order: ' + (data.message || 'Unknown error'));
                        } else {
                            console.log('Folder orders updated successfully');
                        }
                        enablePage();
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('Error updating folder order');
                        enablePage();
                    });
            }

            if (assetOrders.length > 0) {
                fetch('<?php echo e(route("admin.assets.updateOrder")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        asset_orders: assetOrders
                    })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (!data.success) {
                            alert('Error updating folder order: ' + (data.message || 'Unknown error'));
                        } else {
                            console.log('Asset orders updated successfully');
                        }
                        enablePage();
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('Error updating asset order');
                        enablePage();
                    });
            }
        }
    });
</script>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kurdevsv/public_html/resources/views/admin/folders/index.blade.php ENDPATH**/ ?>