<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Promotion</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { background-color: #f5f5f5; }
        .container { margin-top: 50px; }
        .card-panel { padding: 24px; margin-bottom: 30px; }
        .notification {
            padding: 15px; margin-bottom: 20px; border-radius: 4px;
            color: #fff; display: flex; align-items: center;
        }
        .notification.success { background-color: #4CAF50; }
        .notification.error { background-color: #f44336; }
        .notification.info { background-color: #2196F3; }
        .notification.admin-success { background-color: #673AB7; } /* Deep Purple */
        .notification i { margin-right: 10px; }
    </style>
</head>
<body>

<div class="container">
    <div class="row">
        <div class="col s12 m8 offset-m2">

            <div class="card-panel z-depth-2">
                <h4 class="center-align">Promote User to Admin</h4>

                <?php if(session('admin_success')): ?>
                    <div class="notification admin-success"><i class="material-icons">verified_user</i><?php echo e(session('admin_success')); ?></div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="notification error">
                        <i class="material-icons">error</i>
                        <div>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div><?php echo e($error); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('users.promote')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="input-field col s12">
                            <i class="material-icons prefix">supervisor_account</i>
                            <input id="admin_telegram_id" type="number" name="telegram_id" value="<?php echo e(old('telegram_id')); ?>" required>
                            <label for="admin_telegram_id">User's Telegram ID</label>
                            <span class="helper-text">Enter the Telegram ID of the user you want to make an admin.</span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col s12 center-align">
                            <button type="submit" class="btn-large waves-effect waves-light deep-purple">
                                Promote to Admin <i class="material-icons right">security</i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        M.FormSelect.init(document.querySelectorAll('select'));
    });
</script>
</body>
</html>
<?php /**PATH /home/kurdevsv/public_html/resources/views/promote_admin.blade.php ENDPATH**/ ?>