<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Folder extends Model
{
    protected $fillable = ['name', 'description', 'parent_id', 'position'];

    function parent(): BelongsTo
    {
        return $this->belongsTo(Folder::class, 'parent_id');
    }

    function children(): HasMany
    {
        return $this->hasMany(Folder::class, 'parent_id');
    }

    function assets(): HasMany
    {
        return $this->hasMany(Asset::class);
    }

    function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class);
    }

    function getPath(): string
    {
        $path = [$this->name];
        $parent = $this->parent;

        while ($parent) {
            array_unshift($path, $parent->name);
            $parent = $parent->parent;
        }

        return implode(' » ', $path);
    }
}
