<?php

namespace App\Telegram\Menus\Admin;

use SergiX44\Nutgram\Conversations\InlineMenu;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;

class AdminMenu extends InlineMenu
{
    use Helpers;

    static array $adminIds = [1107681202, 488127348, 7866707404, 500296308, 83273854];


    public function start(Nutgram $bot): void
    {
        if (!self::authorizeAdmin($bot, $this)) return;


        $this->menuText("🔧 **Admin Panel**\n\nSelect an option:", ['parse_mode' => 'Markdown'])
//            ->addButtonRow(InlineKeyboardButton::make('📁 Manage Folders', callback_data: 'folders@openFoldersMenu'))
            ->addButtonRow(InlineKeyboardButton::make('📎 Manage Assets', callback_data: 'assets@openAssetsMenu'))
            ->addButtonRow(InlineKeyboardButton::make('👥 Manage Users', callback_data: 'users@openUsersMenu'))
            ->addButtonRow(InlineKeyboardButton::make('📊 Statistics', callback_data: 'stats@openStatsMenu'))
            ->showMenu();
    }


    public function openFoldersMenu(Nutgram $bot): void
    {
        $this->end();
        FoldersMenu::begin($bot);
    }

    public function openAssetsMenu(Nutgram $bot): void
    {
        $this->end();
        AssetsMenu::begin($bot);
    }

    public function openUsersMenu(Nutgram $bot): void
    {
        $this->end();
        UsersMenu::begin($bot);
    }


    public function openStatsMenu(Nutgram $bot): void
    {
        $this->end();
        StatisticsMenu::begin($bot);
    }


    public function fallback(Nutgram $bot): void
    {
        $bot->sendMessage('Invalid selection.');
        $this->start($bot);
    }
}
