<?php

namespace App\Telegram\Menus;

use App\Models\Folder;
use Illuminate\Pagination\LengthAwarePaginator;
use SergiX44\Nutgram\Conversations\InlineMenu;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;

abstract class InlineMenuPaginator extends InlineMenu
{
    protected int $perPage = 8;
    private int|null $parentPage = null;


    abstract protected function renderPage(Nutgram $bot, int|null $folderId, int $page, array $data = null): void;

    public function handleNavigation(Nutgram $bot): void
    {
        [$folderId, $parentPage] = explode(':', $bot->callbackQuery()->data);
        $this->parentPage = $parentPage;

        $this->renderPage($bot, $folderId, 1);
    }

    public function handlePagination(Nutgram $bot): void
    {
        [$folderId, $page] = explode(':', $bot->callbackQuery()->data);
        $this->renderPage($bot, ($folderId == 0 ? null : $folderId), $page ?? 1);
    }


    protected function addControls(LengthAwarePaginator $paginator, ?Folder $currentFolder): void
    {
        $paginationButtons = [];
        $folderIdStr = $currentFolder?->id ?? 0;

        if ($paginator->currentPage() > 1) {
            $previousPage = $paginator->currentPage() - 1;
            $paginationButtons[] = InlineKeyboardButton::make(
                '⬅️ Prev',
                callback_data: "{$folderIdStr}:{$previousPage}@handlePagination"
            );
        }

        if ($paginator->lastPage() > 1) { // Only show page number if there's more than one page
            $paginationButtons[] = InlineKeyboardButton::make(
                "{$paginator->currentPage()}/{$paginator->lastPage()}",
                callback_data: 'noop'
            );
        }

        if ($paginator->hasMorePages()) {
            $nextPage = $paginator->currentPage() + 1;
            $paginationButtons[] = InlineKeyboardButton::make(
                'Next ➡️',
                callback_data: "{$folderIdStr}:{$nextPage}@handlePagination"
            );
        }

        if (!empty($paginationButtons)) $this->addButtonRow(...$paginationButtons);

        if ($currentFolder) {
            $parentPage = $this->parentPage ?? 1;
            $callback = $currentFolder->parent_id
                ? "{$currentFolder->parent_id}:{$parentPage}@handlePagination"
                : "root@start";

            $this->addButtonRow(InlineKeyboardButton::make('⬆️ Up to parent folder', callback_data: $callback));
        }
    }
}
