<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<li class="list-group-item d-flex justify-content-between align-items-center folder-item"
    data-folder-id="<?php echo e($folder->id); ?>"
    style="cursor: pointer; transition: background 0.2s;">
    
    <div class="d-flex align-items-center gap-3">

        <!-- Folder Icon + Name -->
        <strong class="d-flex align-items-center gap-2 fs-5">
            <i class="bi bi-folder2-open text-warning"></i>
            <?php echo e($folder->name); ?>

        </strong>

        <!-- Access Badge -->
        <?php if($folder->users->count() > 0): ?>
            <span class="badge bg-body-secondary text-dark rounded-pill d-flex align-items-center gap-2 px-3 py-2">
                <i class="bi bi-people"></i>
                <?php echo e($folder->users->count()); ?> user<?php echo e($folder->users->count() > 1 ? 's' : ''); ?>

            </span>
        <?php endif; ?>

    </div>

    <a href="<?php echo e(route('admin.folders.confirmDelete', $folder)); ?>"
       class="btn btn-outline-danger btn-sm d-flex align-items-center gap-2"
       onclick="event.stopPropagation()">
        <i class="bi bi-trash"></i>
        Delete
    </a>
</li>

<style>
    .folder-item:hover {
        background: #f8f9fa;
    }
</style>
<?php /**PATH /home/kurdevsv/public_html/resources/views/admin/folders/_folder_list_item.blade.php ENDPATH**/ ?>